set more off
pause off

/**********************************************************************
* Cheaper Faster and More than Good Enough: 
Is GPS the New Gold Standard in Land Area Measurement -- SRM

** File merges data prepared for Ethiopia, Tanzania, and Ngeria

Note: All variables that could potentially be used to identify survey 
respondents have been withheld from public data release. Syntax that 
references these variables may also have been hidden in order to protect 
respondent confidentiality.							

This file creates 2 datasets: 1 appended file with the three experiements 
(all variables) and another re-shaped file with only area measurements.

***********************************************************************/

** COMBINE EXPERIMENTS **

	use "$et_data/CheaperFaster_Ethiopia.dta", clear
		destring plotid, replace
	append using "$zanzi/CheaperFaster_Zanzibar.dta", force
	append using "$nga_data/CheaperFaster_Nigeria.dta", force

	label define survey 1 Ethiopia 2 Tanzania 3 Nigeria
	label val survey survey
	
	count // 4158
	save "all_aggregate.dta", replace

** RESHAPE DATA **

	use "$all_exp", clear
	keep CR_acres GPS_acres SR_acres survey hhid plotid
		
		*create stub
		ren CR_acres 	area_cr
		ren GPS_acres	area_gps
		ren SR_acres 	area_sr
		
	reshape long area_, i(survey hhid plotid) j(method) string
	label var method "measurement method"
	label var area "area (acres)"
	
	save "areas_aggregate.dta", replace
